
markup.push({

	// -------------------------------------------------
	// MARK: bass treble

	BassTrebleBlock: {
		"+": "BlockTemplate",
		geNodeClass: "AHBassTrebleNode",
		h4PresetsId: "BassTreblePresets",
		gxPopoverInfo: "BassTreblePopover",
		gxTitle: "Bass & Treble",
		gxLibraryDescription: "Adjust bass and treble",
		gxLibraryIcon: "library.bass.treble",
		geImporterParams: ["node.bass", "node.treble"],
		gxChildViews:
		{
			bass: {
				"+": "SliderView.blockFace.trackUnfilled",
				gxValueKey: "node.bass",
				gxDetents: "0.5",
				gxDefaultValue: 0.5,
				gxKeystrokeStepSize: 0.005,
				axTitle: "Bass",
				axFormatter: "OffsetFormatter"
			},
			bassLabel: {
				"+": "LabelView.left.foreColorTheme1.size11",
				gxFrameRect: "18,31,83,25",
				gxDefaultValue: "Bass",
			},
			bassReadout: {
				"+": "LabelView.right.blockReadout",
				gxFrameRect: "18,31,83,25",
				gxValueKey: "node.bass",
				gxClickValue: 0.5,
				gxFormatter: "OffsetFormatter"
			},
			treble: {
				"+": "SliderView.blockFace.trackUnfilled",
				gxFrameRect: "14,84,92,23",
				gxValueKey: "node.treble",
				gxDetents: "0.5",
				gxDefaultValue: 0.5,
				gxKeystrokeStepSize: 0.005,
				axTitle: "Treble",
				axFormatter: "OffsetFormatter"
			},
			trebleLabel: {
				"+": "LabelView.left.foreColorTheme1.size11",
				gxFrameRect: "18,66,83,25",
				gxDefaultValue: "Treble",
			},
			trebleReadout: {
				"+": "LabelView.right.blockReadout",
				gxFrameRect: "18,66,83,25",
				gxValueKey: "node.treble",
				gxClickValue: 0.5,
				gxFormatter: "OffsetFormatter"
			}
		}
	},

	// MARK: popover

	BassTreblePopover:
	{
		"+": "PopoverTemplate",
		gxTitle: "Bass & Treble",
		axTitle: "Bass and Treble",
		gxCanDrawSubviewsIntoLayer: true,
		gxWantsLayer: true,
		gxLayout: [ "H:|-12-[self(284)]-12-|",	// sets popover width
					"V:|-12-[self]-12-|",
					"V:|-41-[group]-8-[presetsGroup]"  // sets popover height
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			switch: "PopoverOnOffSwitch",
			presetsGroup: presetsGroup(),
			group: {
				"+": "GroupView",
				gxLayout:
				[
					"H:|-0-[self]-0-|",
					"H:|-12-[bass]-12-|",
					"H:|-12-[treble]-12-|",
					"V:|-30-[bass]-22-[treble]-16-|",

					"V:[bassLabel]-(-1)-[bass]&alignLeft",
					"V:[bassReadout]-(-1)-[bass]&alignRight",

					"V:[trebleLabel]-(-1)-[treble]&alignLeft",
					"V:[trebleReadout]-(-1)-[treble]&alignRight",
				],
				gxChildViews: {
					bass: {
						"+": "SliderView.trackUnfilled",
						gxValueKey: "node.bass",
						gxDetents: "0.5",
						gxDefaultValue: 0.5,
						gxKeystrokeStepSize: 0.005,
						axTitle: "Bass",
						axFormatter: "OffsetFormatter"
					},
					bassLabel: labelView("Bass"),
					bassReadout: {
						"+": "ReadoutView",
						gxValueKey: "node.bass",
						gxClickValue: 0.5,
						gxFormatter: "OffsetFormatter"
					},
					treble: {
						"+": "SliderView.trackUnfilled",
						gxValueKey: "node.treble",
						gxDetents: "0.5",
						gxDefaultValue: 0.5,
						gxKeystrokeStepSize: 0.005,
						axTitle: "Treble",
						axFormatter: "OffsetFormatter"
					},
					trebleLabel: labelView("Treble"),
					trebleReadout: {
						"+": "ReadoutView",
						gxValueKey: "node.treble",
						gxClickValue: 0.5,
						gxFormatter: "OffsetFormatter"
					},
				}
			}
		}
	},


})
